define(['angular', 'app', 'page_service', 'InstitutionsService'], function(angular, app) {
	'use strict';

	app.controller('ChangeLocationModalController', function($scope, $modalInstance, $state, $stateParams, focusService, mhpuser, InstitutionsService) {
		$scope.parentFacilityName = mhpuser.facilityName;
		$scope.institutionOptions = [];

		$scope.$watch(function() {
			return $('div.modal-header h3').is(":visible");
		}, function(isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		InstitutionsService.then(function (institutionService) {
			var MIN_STRING_COMPARISON_VALUE = String.fromCharCode(0);
			var activeInstitution = institutionService.getActiveInstitution();
			var institutions = institutionService.institutions.data;

			$scope.institutionOptions = _.sortBy(institutions, function (institution) {
				// Sort institutions by division name, but ensure the parent facility is always first
				return institution.divisionName === mhpuser.facilityName ? MIN_STRING_COMPARISON_VALUE : institution.divisionName;
			});

			$scope.institutionSelection = _.find(institutions, {divisionName: activeInstitution.divisionName});
			$scope.parentFacility = $scope.institutionSelection.divisionName;
		});

		$scope.ok = function(institutionSelection) {
			InstitutionsService.$$state.value.setActiveInstitution(institutionSelection);
			$state.go("main.auth.two-panel.secondary-navigation.var-utility", {}, {
				reload: true
			});
			$modalInstance.close();
		};

		$scope.cancel = function() {
			$modalInstance.close();
		};

		$scope.getIndex = function(institutionSlection) {
			$scope.parentFacility = institutionSlection.divisionName;
		}
	});
});
